# MONINtab.R (ex-PDItest.R)
# 2008-Ene-05 Viper@upch.edu.pe 2009-Feb-08 

# ======================================================================================================================== #
# call: source("T:/PDItest.R",echo=TRUE,print.eval=TRUE)

setwd("T:\\Temp\\")

date()

#library(foreign) 
library(survey)
library(MASS) 
library(epicalc) 

load( "M.RData" )
sink("p.txt")
pdf("p.pdf")

# ======================================================================================================================== #
# Tabulaciones y graficaciones principales

t<-"===== MONIN (distribucin de conglomerados)";t;date()
t="2008-I (2007-Nov-19 a 2008-Mar-03)"; t; FSamYld ( subset(tc,Periodo==1) )
t="2008-III (2008-Jun-30 a 2008-Oct-04)"; t; FSamYld ( subset(tc,Periodo==2) )
t="2008-IV (2008-Nov-03 a 2008-Dic-30)"; t; FSamYld ( subset(tc,Periodo==3) )
FSamYld ( tc )

t<-"===== MONIN (indicadores principales)";t;date()
FPack1 ( xby=~Estrato, fplot=TRUE, tplot="1ngip" )
FPack1 ( xby=~Periodo, fplot=FALSE, tplot="1ngip" )
FPack1 ( xby=~Crecer, fplot=FALSE, tplot="1ngip" )
FPack1 ( xby=~fINEIE2, fplot=FALSE, tplot="1ngip" )

t<-"===== MONIN (indicadores nutricionales)";t;date()
FPanel1 ( "N5DTE", "Dficit Talla-Edad (<-2z OMS 2006)" )
FPanel1 ( "N5ADE", "Dficit Peso-Talla (<-2z OMS 2006)" )
FPanel1 ( "N5OBE", "Exceso Peso-Talla (>2z OMS 2006)" )
FPanel1 ( "N5Ane", "Hemoglobina <11 g/dL (aj. altura)" )

t<-"===== MONIN (tendencias en el tiempo)";t;date()
t<-"Variable     P0     IC t Total    IC t Crecer   IC t Resto    p tot  p t    p Cr   p int";t
TrendWk ( "N5DTE", p5 )
TrendWk ( "N5ADE", p5 )
TrendWk ( "N5Ane", p5 )
TrendWk ( "IPConLM", subset(p3,EdadM<24) )
TrendWk ( "N5LME", subset(p3,EdadM<6) )
TrendWk ( "IPVComio", subset(p3,EdadM>=6 & EdadM<24) )
TrendWk ( "N5Ali", subset(p5,N5SaY==0) )
TrendWk ( "N5CC0", subset(p3,EdadM<24) )
TrendWk ( "N5PIP", subset(p3,EdadM<24) )
TrendWk ( "IPNMSD", p5 )
TrendWk ( "IPAlumbra", p5 )
TrendWk ( "IPAgua", p5 )
TrendWk ( "IPAgRTC", p5 )
TrendWk ( "IPAgRTH", p5 )
TrendWk ( "IPExcre1", p5 )
TrendWk ( "IPExcre3", p5 )
TrendWk ( "IPTCoc1", p5 )
TrendWk ( "IPTCoc2", p5 )
TrendWk ( "IPCUI", p5 )
TrendWk ( "IPNBI", p5 )
TrendWk ( "IPNJtos", subset(p5,NBI>0) )
TrendWk ( "IPSIS", subset(p5,NBI>0) )
TrendWk ( "IPNBAA", subset(p5,NBI>0) )
TrendWk ( "IPNPapB", subset(p5,NBI>0) )
TrendWk ( "IPNBAA", subset(p5,NBI==0) )
TrendWk ( "IPNBPIN", subset(p5,NBI>0) )
TrendWk ( "IPNBVAL", subset(p5,NBI>0) )

t<-"===== MONIN (indicadores de Crecer)";t;date()
table(n5$EtapaC)
table(n5$Crecer)
svymean(~ifelse(EtapaC>0,1,0),p5,na.rm=TRUE,deff=FALSE)
svyby(~ifelse(EtapaC>0,1,0),~Estrato,design=p5,svymean,na.rm=TRUE,deff=FALSE)
t<-"===== Nios 0-59 meses, Indicadores Crecer - Decreto Supremo 080";t
FPRwM2 ( ~ifelse(NBI>0,1,0), p5,                           "NBI>0                ", xby=~Crecer )
FPRwM2 ( ~ifelse(ZHAZ<(-2),1,0), p5,                       "TE <-2zs OMS 2006    ", xby=~Crecer )
FPRwM2 ( ~N5LME, subset(p3,EdadM<6),                       "Lact. M. Excl. [<6m] ", xby=~Crecer )
FPRwM2 ( ~ifelse(HbCORR<11,1,0), p3,                       "Hbc<11 [<36m]        ", xby=~Crecer )
FPRwR2 ( ~NumeIR, ~DenomIR, p3,                            "Inc. Enf. Resp. Ag.  ", xby=~Crecer )
FPRwR2 ( ~NumeID, ~DenomID, p3,                            "Inc. Enf. Diarr. Ag. ", xby=~Crecer )
FPRwM2 ( ~ifelse(CUI==1,1,0), p5,                          "CUI                  ", xby=~Crecer )
# mismos indicadores, segn UR
FPRwM2 ( ~ifelse(NBI>0,1,0), p5,                           "NBI>0                ", xby=~INEIE2 )
FPRwM2 ( ~ifelse(ZHAZ<(-2),1,0), p5,                       "TE <-2zs OMS 2006    ", xby=~INEIE2 )
FPRwM2 ( ~N5LME, subset(p3,EdadM<6),                       "Lact. M. Excl. [<6m] ", xby=~INEIE2 )
FPRwM2 ( ~ifelse(HbCORR<11,1,0), p3,                       "Hbc<11 [<36m]        ", xby=~INEIE2 )
FPRwR2 ( ~NumeIR, ~DenomIR, p3,                            "Inc. Enf. Resp. Ag.  ", xby=~INEIE2 )
FPRwR2 ( ~NumeID, ~DenomID, p3,                            "Inc. Enf. Diarr. Ag. ", xby=~INEIE2 )
FPRwM2 ( ~ifelse(CUI==1,1,0), p5,                          "CUI                  ", xby=~INEIE2 )
# indicadores adicionales: anemia y prevalencia EDA
FPRwM2 ( ~ifelse(HbCORR<11,1,0), p3,                       "Hbc<11 [<36m]        ", xby=~INEIE2 )
FPRwR2 ( ~NED7, ~DenomP, p3,                               "EDA p 1d [<36m]      ", xby=~INEIE2 )
# FPRwR2 ( ~IPPDia2w, ~one, p3,                              "EDA p 2s [<36m]      ", xby=~INEIE2 )
FPRwM2 ( ~ifelse(PDia2w==1,1,0), p3,                       "EDA p 2s [<36m]      ", xby=~INEIE2 )
FPRwM2 ( ~ifelse(HbCORR<11,1,0), p5,                       "Hbc<11 [<59m]        ", xby=~INEIE2 )
FPRwM2 ( ~ifelse(PDia2w==1,1,0), p5,                       "EDA p 2s [<59m]      ", xby=~INEIE2 )
FPRwR2 ( ~NER7, ~DenomP, p5,                               "IRA p 1d [<59m]      ", xby=~INEIE2 )
FPRwM2 ( ~ifelse(PTos2w==1,1,0), p5,                       "IRA p 2s [<59m]      ", xby=~INEIE2 )
FPRwR2 ( ~NumeIR, ~DenomIR, p5,                            "Inc. Enf. Resp. Ag.  ", xby=~INEIE2 )

t<-"===== Nios 0-59 meses, Indicadores Crecer - Presentacin de Estrategia";t
FPRwM2 ( ~ifelse(ConLM==2,0,ConLM), subset(p3,EdadM<24),   "Lact. Materna   [<24]", xby=~Crecer )
FPRwM2 ( ~ifelse(VComio>=3,1,0), subset(p3,EdadM<24),      "Comi 3+ SS     [<24]", xby=~Crecer )
FPRwM2 ( ~MasGra, subset(p3,EdadM<24),                     "Grasa adicional [<24]", xby=~Crecer )
FPRwM2 ( ~ifelse(NMSD==1,1,0), p5,                         "Sesin demostrativa  ", xby=~Crecer )
FPRwM2 ( ~ifelse(NBAA>0,1,0), subset(p5,NBI>0),            "Asistencia Alim.[NBI]", xby=~Crecer )
FPRwM2 ( ~ifelse(NJtos>0,1,0), subset(p5,NBI>0),           "Juntos          [NBI]", xby=~Crecer )
FPRwM2 ( ~ifelse(VitA==1,1,0), subset(p3,EdadM<24),        "Supl. Vit. A    [<24]", xby=~Crecer )
FPRwM2 ( ~ifelse(VFe>5,1,0), subset(p3,EdadM<24),          "Supl. Fe        [<24]", xby=~Crecer )
FPRwM2 ( ~ifelse(Alumbra==1,1,0), p5,                      "Electricidad         ", xby=~Crecer )
FPRwM2 ( ~ifelse(Agua==1,1,0), p5,                         "Agua en Red dentro   ", xby=~Crecer )
FPRwM2 ( ~ifelse(AgRT==2|AgRT==3,1,0), p5,                 "Recibe Agua Clorada  ", xby=~Crecer )
FPRwM2 ( ~ifelse(AgRT==1|AgRT==3,1,0), p5,                 "Consume Agua Hervida ", xby=~Crecer )
FPRwM2 ( ~ifelse(Excre==1,1,0), p5,                        "Desage en Red dentro", xby=~Crecer )
FPRwM2 ( ~ifelse(Excre>1&Excre<5,1,0), p5,                 "Letrina/Pozo/Red f   ", xby=~Crecer )
FPRwM2 ( ~ifelse(Excre==3&LetOK==1,1,0), p5,               "Letrina adecuada      ", xby=~Crecer )
FPRwM2 ( ~ifelse(TCoc==1,1,0), p5,                         "Combustible Elec/Gas ", xby=~Crecer )
FPRwM2 ( ~ifelse(TCoc==2,1,0), p5,                         "Cocina Asesorada     ", xby=~Crecer )
FPRwM2 ( ~ifelse(MaEdu>1,1,0), p5,                         "Madre Alfabeta       ", xby=~Crecer )
FPRwM2 ( ~N5CC0, p5,                                       "CRED al dia 1er ao  ", xby=~Crecer )
FPRwM2 ( ~N5PIP, p5,                                       "PAI al dia           ", xby=~Crecer )
FPRwM2 ( ~ifelse(SIS==1|SIS==2,1,0), subset(p5,NBI>0),            "SIS             [NBI]", xby=~Crecer )
FPack1 ( xby=~Crecer, fplot=TRUE )
FPTbMR ( xvec=c(~IPNBPIN,~IPNBVAL),
	 xdes=list(subset(p5,NBI>0),subset(p5,NBI>0)),
	 xlab=c("PIN[P]","VL[P]"), 
	 xby=~Crecer, fratio=FALSE, fplot=FALSE ) 

# ======================================================================================================================== #

q("no")
